﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomEntityEditor(typeof(HexProximityTriggerModel))]
    public class ProximityTriggerEntityEditor : EntityEditor
    {
        private static Color MASK_COLOR = new Color(0, 1, 0, 0.3f);

        public override void OnDrawSelection()
        {
            HexProximityTriggerModel trigger = Target as HexProximityTriggerModel;

            using (new Handles.DrawingScope(MASK_COLOR))
            {
                Vector2Int axialPosition = HexHelper.OddToAxial(trigger.Position);
                for (int i = -trigger.Range; i <= trigger.Range; i++)
                {
                    for (int j = -trigger.Range; j <= trigger.Range; j++)
                    {
                        Vector2Int position = axialPosition + new Vector2Int(i, j);
                        if (HexHelper.AxialDistance(axialPosition, position) < trigger.Range)
                        {
                            Handles.DrawAAConvexPolygon(HexHelper.GetTileCorners(HexHelper.GetTilePosition(HexHelper.AxialToOdd(position))));
                        }
                    }
                }
            }
        }
    }
}
