﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public abstract class MapEditorTool
    {
        protected static Vector2 BUTTON_SIZE = new Vector2(75, 75);

        protected HexMapEditorWindow _editor;
        protected HexMapWritableView _view;

        public void Initialize(HexMapEditorWindow editor, HexMapWritableView view)
        {
            _editor = editor;
            _view = view;
        }

        public virtual void OnInspectorPanel() { }
        public virtual void OnDrawHandle() { }
        public virtual void OnClear() { }

        public virtual void OnMouseMove() { }
        public virtual void OnMouseDown() { }
        public virtual void OnMouseClick() { }
        public virtual void OnKeyDown() { }

        protected void DrawTileHandle(Vector2Int position)
        {
            DrawTileHandle(position, Color.white);
        }

        protected void DrawTileHandle(Vector2Int position, Color color)
        {
            using (new Handles.DrawingScope(color, _view.transform.localToWorldMatrix))
            {
                Handles.DrawPolyLine(HexHelper.GetTileCorners(HexHelper.GetTilePosition(position)));
            }
        }

        protected void DrawSpriteHandle(Sprite sprite, Vector2 position)
        {
            GraphicsExt.DrawSprite(sprite, (Vector3)position + Vector3.back, Color.white * 0.75f);
        }

        protected void RecordUndo()
        {
            _editor.RecordUndo();
        }

        protected Vector3 GetMouseWorldPosition()
        {
            return HandleUtility.GUIPointToWorldRay(Event.current.mousePosition).origin;
        }
    }
}
