﻿using UnityEngine;

namespace PK
{
    public class PlaceHeroesTool : GenericPlacingTool<HexHero>
    {
        protected override HexHero[] Data => HexDatabase.Instance.Heroes;

        protected override Texture2D GetIcon(HexHero instance)
        {
            return _editor.GetIcon(instance.AnySprite);
        }

        protected override void Place()
        {
            if (_view.CanPlaceHero(_hoveredTile))
            {
                RecordUndo();
                _view.PlaceHero(_hoveredTile, _brushSelectedInstance);
            }
        }

        public override void OnDrawHandle()
        {
            if (_brushSelectedInstance != null)
            {
                DrawTileHandle(_hoveredTile);
                Vector3 position = GetMouseWorldPosition();
                DrawSpriteHandle(_brushSelectedInstance.AnySprite, HexHelper.GetTilePosition(HexHelper.GetHexPosition(position)));
            }
        }
    }
}
