﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public class SettingsTool : MapEditorTool
    {
        private static string DRAW_GRID_KEY = "DrawGrid";
        private static string DRAW_INTERACTION_MASK_KEY = "DrawInteractionMask";

        public static bool DrawGrid { get { return EditorPrefs.GetBool(DRAW_GRID_KEY); } set { EditorPrefs.SetBool(DRAW_GRID_KEY, value); } }
        public static bool DrawInteractionMask { get { return EditorPrefs.GetBool(DRAW_INTERACTION_MASK_KEY); } set { EditorPrefs.SetBool(DRAW_INTERACTION_MASK_KEY, value); } }

        public override void OnInspectorPanel()
        {
            EditorGUI.BeginChangeCheck();
            DrawGrid = GUILayout.Toggle(DrawGrid, "Draw grid");
            DrawInteractionMask = GUILayout.Toggle(DrawInteractionMask, "Draw interaction mask");
            if (EditorGUI.EndChangeCheck())
            {
                SceneView.RepaintAll();
            }
        }
    }
}
