﻿using DG.Tweening;
using UnityEngine;

namespace PK
{
    public class HexHeroView : HexEntityView
    {
        const float WALKING_TIME = 0.5f / 1.5f;

        private static int _isMovingId = Animator.StringToHash("IsMoving");
        private static int _directionId = Animator.StringToHash("Direction");

        private HexHero _hero;

        private SpriteRenderer _spriteRenderer;
        private Animator _animator;
        private Transform _transform;
        
        public override Bounds Bounds { get { return SpriteHelper.GetBounds(_spriteRenderer); } }
        public override Vector3 Position { get { return _transform.position; } }

        public override void Initialize(IEntityModelForView modelForView)
        {
            _uid = modelForView.Uid;
            _id = modelForView.Id;
            _hero = HexDatabase.Instance.GetHero(_uid);

            if (_spriteRenderer == null)
            {
                _spriteRenderer = GetComponent<SpriteRenderer>();
                _spriteRenderer.sharedMaterial = HexMaterials.Instance.CreatureMaterial;
                _spriteRenderer.sortingOrder = SortingOrder.ENTITY;
                _animator = GetComponent<Animator>();
                _transform = transform;
            }

            if (Application.isPlaying)
            {
                _spriteRenderer.enabled = modelForView.Enabled;
            }
            else
            {
                _spriteRenderer.sharedMaterial = modelForView.Enabled ? HexMaterials.Instance.CreatureMaterial : HexMaterials.Instance.ObjectInvisibleMaterial;
            }

            Move(modelForView.Position, Vector2.zero);
        }

        public override void SetActive(bool active)
        {
            if (Application.isPlaying)
            {
                _spriteRenderer.enabled = active;
            }
        }

        public override void Move(Vector2Int position, Vector2 offset)
        {
            _transform.position = GetPosition(position);
        }

        public void Walk(Vector2Int start, Vector2Int end, System.Action callback)
        {
            _animator.SetBool(_isMovingId, true);

            Vector2Int axialDelta = HexHelper.OddToAxial(end) - HexHelper.OddToAxial(start);
            for (int i = 0; i < 6; i++)
            {
                if (axialDelta == HexHelper.AXIAL_DIRECTIONS[i])
                {
                    _animator.SetFloat(_directionId, i / 5.0f);
                    break;
                }
            }
            _transform.position = GetPosition(start);
            _transform.DOMove(GetPosition(end), WALKING_TIME).SetEase(Ease.Linear).OnComplete(() =>
            {
                _animator.SetBool(_isMovingId, false);
                callback?.Invoke();
            });
        }

        private static Vector3 GetPosition(Vector2Int position)
        {
            return HexHelper.GetTilePosition(position) + Vector3.back * 0.1f;
        }
    }
}
