﻿using System;
using UnityEngine;

namespace PK
{
    public class HexTechicalView : HexEntityView
    {
        private SpriteRenderer _spriteRenderer;
        private Transform _transform;

        public override Bounds Bounds { get { return SpriteHelper.GetBounds(_spriteRenderer); } }
        public override Vector3 Position { get { return _transform.position; } }

        public override void Initialize(IEntityModelForView modelForView)
        {
#if UNITY_EDITOR
            if (_spriteRenderer == null)
            {
                _spriteRenderer = gameObject.AddComponent<SpriteRenderer>();
                _spriteRenderer.material = HexMaterials.Instance.ObjectMaterial;
                _spriteRenderer.sortingOrder = SortingOrder.ENTITY;
                _transform = transform;
            }

            if (!Application.isPlaying)
            {
                if (modelForView.Type == EntityType.ProximityTrigger)
                {
                    _spriteRenderer.sprite = HexDatabase.Instance.ProximityTriggerIcon;
                }
                if (modelForView.Type == EntityType.SpawnPoint)
                {
                    _spriteRenderer.sprite = HexDatabase.Instance.SpawnPointIcon;
                }
                if (modelForView.Type == EntityType.MapZone)
                {
                    _spriteRenderer.sprite = HexDatabase.Instance.MapZoneIcon;
                }
            }

            Move(modelForView.Position, Vector2.zero);
#endif
        }

        public override void Move(Vector2Int position, Vector2 offset)
        {
            _transform.position = GetPosition(position);
        }

        private static Vector3 GetPosition(Vector2Int position)
        {
            return HexHelper.GetTilePosition(position) + Vector3.back * 0.1f;
        }
    }
}
