﻿#ifndef SHADOWS_INCLUDED
#define SHADOWS_INCLUDED

TEXTURE2D(_Shadows);
SAMPLER(sampler_Shadows);

float3 CastShadow(float4 shadowData, float alpha)  // r - cast shadow mask, g - receive shadow mask, b - sprite y
{
	return float3(shadowData.b * (shadowData.r > 0), shadowData.r, alpha);
}

half4 ApplyShadows(float2 normalizedScreenSpaceUV, half4 color)
{
	float4 shadows = SAMPLE_TEXTURE2D(_Shadows, sampler_Shadows, normalizedScreenSpaceUV);
	color.rgb = lerp(color.rgb, float3(0, 0, 0), (shadows.g > 0) * (0.5 * shadows.b));
	return color;
}

half4 ApplyShadows(float2 normalizedScreenSpaceUV, float4 shadowData, half4 color)
{
	float4 shadows = SAMPLE_TEXTURE2D(_Shadows, sampler_Shadows, normalizedScreenSpaceUV);
	color.rgb = lerp(color.rgb, float3(0, 0, 0), (((int)shadows.g & (int)shadowData.g) > 0) * (shadows.r < shadowData.b) * (0.5 * shadows.b));
	return color;
}

#endif