#!/bin/bash

shopt -s nullglob

readonly CODE_SLEEP_TIME=60 # sleep for N secs between code requests
readonly DEPOTS_ROOT="/tmp/depots/"
readonly BUILD_OUTPUT_DIR="/tmp/steam_build_output"
readonly BUILD_DESC="build${BUILD_NUMBER?}"
readonly STEAM_SCRIPT_FILE_RESOLVED=$(realpath ${STEAM_SCRIPT_FILE?})

readonly MAC64_DEPOT_ROOT="${DEPOTS_ROOT?}/mac-64-release"
readonly WIN64_DEPOT_ROOT="${DEPOTS_ROOT?}/win-64-release"

rm -Rf "${MAC64_DEPOT_ROOT}"
rm -Rf "${WIN64_DEPOT_ROOT}"

mkdir -p "${MAC64_DEPOT_ROOT}"
mkdir -p "${WIN64_DEPOT_ROOT}"

files=(${MAC64_BUILD?})
if [ ${#files[@]} -eq 0 ]; then
    echo "Mac build not found"
    exit 1
fi

files=(${WIN64_BUILD?})
if [ ${#files[@]} -eq 0 ]; then
    echo "Win build not found"
    exit 1
fi

unzip "${MAC64_BUILD?}" -d "${MAC64_DEPOT_ROOT}"
unzip "${WIN64_BUILD?}" -d "${WIN64_DEPOT_ROOT}"

echo "Using steam script file: ${STEAM_SCRIPT_FILE?}"

# patch steam script file
sed -i "s~\"setlive\" \"TARGET_BRANCH\"~\"setlive\" \"${STEAM_BRANCH?}\"~" "${STEAM_SCRIPT_FILE?}"

mkdir -p "$BUILD_OUTPUT_DIR"


echo "Uploading to branch: ${STEAM_BRANCH}"
echo "Build number: ${BUILD_NUMBER?}"

# run once to update before getting OTP
/home/steam/steamcmd/steamcmd.sh +quit

readonly STEAM_GUARD=$(steam-otp --secret ${STEAM_SHARED_SECRET?})
echo "Got OTP code: ${STEAM_GUARD}"

/home/steam/steamcmd/steamcmd.sh \
    +login "${STEAM_USERNAME?}" "${STEAM_PASSWORD?}" "${STEAM_GUARD}" \
    +run_app_build\
    -desc "${BUILD_DESC?}"\
    -contentroot "${DEPOTS_ROOT?}" \
    -buildoutput "${BUILD_OUTPUT_DIR?}" \
    "${STEAM_SCRIPT_FILE_RESOLVED?}" \
    +quit

STEAM_EXIT_CODE=$?
echo "Steam exited with code ${STEAM_EXIT_CODE?}"
exit $STEAM_EXIT_CODE